<?php

/**
 * This is the model class for table "Formularz".
 *
 * The followings are the available columns in table 'Formularz':
 * @property double $id
 * @property string $nazwa
 */
class Formularz extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return Formularz the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'Formularz';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		return array(
			array('nazwa', 'length', 'max'=>64),

			array('id, nazwa', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		return array(
			'szkolenies'=>array(self::HAS_MANY, 'Szkolenie', 'idFormularzu'),
			'zlecenies'=>array(self::HAS_MANY, 'Zlecenie', 'idFormularza'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id'=>Yii::t('Formularz', 'id'),
			'nazwa'=>Yii::t('Formularz', 'nazwa'),
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		$criteria = new CDbCriteria;

		$criteria->compare('id', $this->id);
		$criteria->compare('nazwa', $this->nazwa, true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	public function getActionHash()
	{
		switch($this->id)
		{
			case 1:
				return "intUPs2";
			break;
			case 2:
				return "internetCEIDG";
			break;
			case 3:
				return "intUSs_pit36";
			break;
			case 4:
				return "intUSs_nip";
			break;
			case 5:
				return "intUSs_vat7";
			break;
			case 6:
				return "intUPs1";
			break;
			case 7:
				return "intUSs_vat7k";
			break;
			case 8:
				return "intUSs_vatr";
			break;
			case 9:
				return "intZs_dra";
			break;
			case 10:
				return "intZs_rca";
			break;
			case 11:
				return "intZs_zua";
			break;
			default:
				return "";
			break;
		}
	}
    
}
